/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.utils.mapui;

import filenet.vw.toolkit.utils.mapui.IVWRouteRender;
import filenet.vw.toolkit.utils.mapui.VWBaseRouteUI;
import filenet.vw.toolkit.utils.mapui.VWStepRouteColors;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

class VWRouteLineRender
implements IVWRouteRender {
    private VWBaseRouteUI m_route = null;
    private VWStepRouteColors m_stepRouteColors = null;
    private Point m_srcPt = null;
    private Point m_startPt = null;
    private Point m_endPt = null;
    private double m_angle = 0.0;
    private int[] m_arrowXPts = new int[3];
    private int[] m_arrowYPts = new int[3];

    protected VWRouteLineRender(VWBaseRouteUI route) {
        this.m_route = route;
        if (this.m_route != null) {
            this.m_stepRouteColors = this.m_route.getStepRouteColors();
        }
    }

    public boolean contains(Point loc) {
        double delta = 10.0;
        double toLocX = (double)this.m_endPt.x - (double)this.m_srcPt.x;
        double toLocY = (double)this.m_endPt.y - (double)this.m_srcPt.y;
        double locX = (double)loc.x - (double)this.m_srcPt.x;
        double locY = (double)loc.y - (double)this.m_srcPt.y;
        double distY = toLocX != 0.0 ? Math.abs(locY - toLocY / toLocX * locX) : Math.abs(locY);
        if (distY <= 10.0 && (toLocX < 0.0 ? locX >= toLocX && locX <= 0.0 : locX <= toLocX && locX >= 0.0)) {
            return true;
        }
        double distX = toLocY != 0.0 ? Math.abs(locX - toLocX / toLocY * locY) : Math.abs(locY);
        return distX <= 10.0 && (toLocY < 0.0 ? locY >= toLocY && locY <= 0.0 : locY <= toLocY && locY >= 0.0);
    }

    public Rectangle getBounds() {
        Rectangle rect = new Rectangle();
        rect.x = this.m_srcPt.x < this.m_endPt.x ? this.m_srcPt.x - 5 : this.m_endPt.x - 5;
        rect.y = this.m_srcPt.y < this.m_endPt.y ? this.m_srcPt.y - 5 : this.m_endPt.y - 5;
        rect.width = Math.abs(this.m_endPt.x - this.m_srcPt.x) + 10;
        rect.height = Math.abs(this.m_endPt.y - this.m_srcPt.y) + 20;
        return rect;
    }

    public void calcCoords() {
        Point destLoc = this.m_route.m_destStep.getImageCenterLocation();
        this.m_srcPt = this.m_route.m_srcStep.getImageCenterLocation();
        double horz = destLoc.x - this.m_srcPt.x;
        double vert = destLoc.y - this.m_srcPt.y;
        if (horz != 0.0) {
            this.m_angle = Math.atan(vert / horz);
            if (horz < 0.0) {
                this.m_angle = vert > 0.0 ? Math.PI + this.m_angle : -Math.PI + this.m_angle;
            }
        } else {
            this.m_angle = vert > 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        double reverseAngle = this.m_angle == 0.0 ? Math.PI : (this.m_angle > 0.0 ? this.m_angle - Math.PI : Math.PI + this.m_angle);
        this.m_endPt = this.m_route.m_destStep.getBoundaryPoint(reverseAngle, true);
        this.m_startPt = this.m_route.m_srcStep.getBoundaryPoint(this.m_angle, true);
        this.createArrowHead();
    }

    private void createArrowHead() {
        double height = 14.0;
        double width = 12.0;
        double r = Math.sqrt(193.0);
        double theta = Math.atan2(7.0, 12.0);
        this.m_arrowXPts[0] = this.m_endPt.x;
        this.m_arrowYPts[0] = this.m_endPt.y;
        this.m_arrowXPts[1] = (int)Math.round((double)this.m_endPt.x + r * Math.cos(this.m_angle + Math.PI + theta));
        this.m_arrowYPts[1] = (int)Math.round((double)this.m_endPt.y + r * Math.sin(this.m_angle + Math.PI + theta));
        this.m_arrowXPts[2] = (int)Math.round((double)this.m_endPt.x + r * Math.cos(this.m_angle + Math.PI - theta));
        this.m_arrowYPts[2] = (int)Math.round((double)this.m_endPt.y + r * Math.sin(this.m_angle + Math.PI - theta));
    }

    public void paintComponent(Graphics g) {
        if (!this.m_route.m_srcStep.contains(this.m_endPt)) {
            Color curColor = g.getColor();
            if (this.m_route.getFocus()) {
                g.setColor(this.m_stepRouteColors.getFocusColor());
            } else if (this.m_route.getSelect()) {
                g.setColor(this.m_stepRouteColors.getSelectionColor());
            } else {
                g.setColor(this.m_stepRouteColors.getDefaultColor());
            }
            g.drawLine(this.m_startPt.x, this.m_startPt.y, this.m_endPt.x, this.m_endPt.y);
            g.fillPolygon(this.m_arrowXPts, this.m_arrowYPts, 3);
            g.setColor(curColor);
        }
    }

    public void printComponent(Graphics2D g2, int pageX, int pageY) {
        if (!this.m_route.m_srcStep.contains(this.m_endPt)) {
            int idx;
            Color curColor = g2.getColor();
            g2.setColor(Color.black);
            g2.drawLine(this.m_startPt.x - pageX, this.m_startPt.y - pageY, this.m_endPt.x - pageX, this.m_endPt.y - pageY);
            int[] arrowX = new int[3];
            int[] arrowY = new int[3];
            for (idx = 0; idx < 3; ++idx) {
                arrowX[idx] = this.m_arrowXPts[idx] - pageX;
            }
            for (idx = 0; idx < 3; ++idx) {
                arrowY[idx] = this.m_arrowYPts[idx] - pageY;
            }
            g2.fillPolygon(arrowX, arrowY, 3);
            g2.setColor(curColor);
        }
    }

    public Point getPoint(double dist) {
        Point pt = null;
        double deltaY = this.m_endPt.y - this.m_srcPt.y;
        double deltaX = this.m_endPt.x - this.m_srcPt.x;
        double len = Math.sqrt(deltaY * deltaY + deltaX * deltaX);
        if (dist >= len) {
            return null;
        }
        pt = new Point(0, 0);
        pt.x = (int)(dist / len * deltaX) + this.m_srcPt.x;
        pt.y = (int)(dist / len * deltaY) + this.m_srcPt.y;
        return pt;
    }

    public Point getPoint(int percent) {
        if (percent < 0 || percent > 100) {
            return null;
        }
        Point pt = null;
        double deltaY = this.m_endPt.y - this.m_srcPt.y;
        double deltaX = this.m_endPt.x - this.m_srcPt.x;
        pt = new Point(0, 0);
        double dPercent = (double)percent / 100.0;
        pt.x = (int)(dPercent * deltaX) + this.m_srcPt.x;
        pt.y = (int)(dPercent * deltaY) + this.m_srcPt.y;
        return pt;
    }

    public Point getCenterPoint() {
        Point pt = new Point(0, 0);
        double deltaY = this.m_endPt.y - this.m_srcPt.y;
        double deltaX = this.m_endPt.x - this.m_srcPt.x;
        pt.x = (int)(deltaX / 2.0) + this.m_srcPt.x;
        pt.y = (int)(deltaY / 2.0) + this.m_srcPt.y;
        return pt;
    }
}

